document.addEventListener('DOMContentLoaded', () => {
    const appointmentForm = document.getElementById('appointmentForm');
    const successModalOverlay = document.getElementById('successModalOverlay');
    const themeToggleBtn = document.getElementById('theme-toggle-btn');

    //переключение темы
    if (themeToggleBtn) {
        const currentTheme = localStorage.getItem('theme');
        if (currentTheme) {
            document.body.setAttribute('data-theme', currentTheme);
        }

        themeToggleBtn.addEventListener('click', () => {
            let theme = document.body.getAttribute('data-theme');
            if (theme === 'dark') {
                document.body.removeAttribute('data-theme');
                localStorage.removeItem('theme');
            } else {
                document.body.setAttribute('data-theme', 'dark');
                localStorage.setItem('theme', 'dark');
            }
        });
    }

    //проверка на заполнение
    if (appointmentForm) {
        const successModalOverlay = document.getElementById('successModalOverlay');
        const closeModalBtn = document.getElementById('closeModalBtn');

        if (successModalOverlay && closeModalBtn) {
            appointmentForm.addEventListener('submit', function(event) {
                event.preventDefault();
                successModalOverlay.classList.add('show');
            });

            closeModalBtn.addEventListener('click', function() {
                window.location.href = 'index.html';
            });

            successModalOverlay.addEventListener('click', function(event) {
                if (event.target === successModalOverlay) {
                    successModalOverlay.classList.remove('show');
                }
            });
        }
    }
    
    //маска для ввода телефона в записи на прием
    const phoneInput = document.getElementById('phone');
    if (phoneInput) {
        const phoneMask = IMask(phoneInput, {
            mask: '+{7} (000) 000-00-00'
        });
    }

    //маска для ввода даты в записи на прием
    const dateInput = document.getElementById('datetime');
    if (dateInput) {
        const dateMask = IMask(dateInput, {
            mask: Date,
            pattern: 'd.`m.`Y',
            blocks: {
                d: {
                    mask: IMask.MaskedRange,
                    from: 1,
                    to: 31,
                    maxLength: 2,
                },
                m: {
                    mask: IMask.MaskedRange,
                    from: 1,
                    to: 12,
                    maxLength: 2,
                },
                Y: {
                    mask: IMask.MaskedRange,
                    from: new Date().getFullYear(),
                    to: new Date().getFullYear() + 5,
                }
            },
            format: function (date) {
                let day = date.getDate();
                let month = date.getMonth() + 1;
                const year = date.getFullYear();

                if (day < 10) day = "0" + day;
                if (month < 10) month = "0" + month;

                return [day, month, year].join('.');
            },
            parse: function (str) {
                const yearMonthDay = str.split('.');
                return new Date(yearMonthDay[2], yearMonthDay[1] - 1, yearMonthDay[0]);
            }
        });
    }
});